const generateRRule = async (date_type, event_date) => {
    let rruleString = '';
    const eventDate = new Date(event_date);

    switch (date_type) {
        case 'single':
            // For a single event on a specific date
            rruleString = '';
            break;
        case 'daily':
            // For daily recurring event
            rruleString = `RRULE:FREQ=DAILY;COUNT=365`; // Example: daily for 365 days
            break;
        case 'weekly':
            // For weekly recurring event
            rruleString = `RRULE:FREQ=WEEKLY;BYDAY=${eventDate.getDay()};COUNT=52`; // Example: weekly on the day of the week of event_date for 52 weeks
            break;
        case 'monthly':
            // For monthly recurring event
            rruleString = `RRULE:FREQ=MONTHLY;BYMONTHDAY=${eventDate.getDate()};COUNT=12`; // Example: monthly on the day of the month of event_date for 12 months
            break;
        default:
            throw new Error('Invalid date_type');
    }

    return rruleString;
};
module.exports = { generateRRule };
