const TestimonialRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const testimonialController = require('../controller/testimonial.controller');

module.exports = (app) => {
    TestimonialRouter.post('/', websiteImageUpload, testimonialController.create);

    // get all

    TestimonialRouter.get('/', testimonialController.getAll);

    // get active data

    TestimonialRouter.get('/active', testimonialController.getActiveData);

    // get one

    TestimonialRouter.get('/:id', testimonialController.getOne);

    // update

    TestimonialRouter.put('/:id', websiteImageUpload, testimonialController.update);

    // delete

    TestimonialRouter.delete('/:id', testimonialController.delete);

    app.use('/api/testimonial', TestimonialRouter);
};
