const errorResponse = require("../../../../utils/errorResponse");
const successResponse = require("../../../../utils/successResponse");

const { model } = require("../../../../config/database.config");

const { team_members: TeamMembersModel, social_icon_list: SocialIconModel } =
  model;

// const { TeamMembersModel, SocialIconModel } = require(".");

exports.getActiveData = async (req, res) => {
  try {
    const result = await TeamMembersModel.findAll({
      where: {
        status: 1,
      },
      include: [
        {
          model: SocialIconModel,
        },
      ],
      order: [["order_no", "ASC"]],
    });
    //
    // if (!result) {
    //   return errorResponse(404, "NOT FOUND", "NO Active data found", res);
    // }
    //
    return successResponse(200, "OK", result, res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err.message || "There was a server side Error",
      res,
    );
  }
};

exports.getActiveSingleData = async (req, res) => {
  try {
    const { id } = req.params;
    const result = await TeamMembersModel.findOne({
      where: {
        id,
        status: 1,
      },
      include: [
        {
          model: SocialIconModel,
        },
      ],
    });

    if (!result) {
      return errorResponse(404, "NOT FOUND", "NO Active data found", res);
    }

    return successResponse(200, "OK", result, res);
  } catch (error) {
    return errorResponse(
      500,
      "ERROR",
      error.message || "There is a server side problem",
      res,
    );
  }
};
