const { Op } = require('sequelize');
const db = require('../../../../config/database.config');
const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');

const { user_payment: UserPayment } = db.model;

exports.getUserPaymentData = async (req, res) => {
    try {
        const { user } = req;
        console.log(user);

        const paymentData = await UserPayment.findAll({
            where: {
                [Op.or]: [{ user_id: user.id }, { user_mobile: user?.mobile }],
            },
        });

        return successResponse(200, 'OK', paymentData, res);
    } catch (err) {
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while creating order id',
            res
        );
    }
};
