const PackageCatRouter = require('express').Router();
const packageController = require('../controllers/packageCat.controllers');

module.exports = (app) => {
    // get all thhe package category
    PackageCatRouter.get('/', packageController.findAll);

    // post package category
    PackageCatRouter.post('/', packageController.createPackageCat);

    // update package category

    PackageCatRouter.put('/:id', packageController.update);

    // delete package category

    PackageCatRouter.delete('/:id', packageController.delete);

    // get all active package

    PackageCatRouter.get('/active', packageController.getActivePackage);

    app.use('/api/package-category', PackageCatRouter);
};
