module.exports = (sequelize, DataTypes) => {
    const packageCat = sequelize.define(
        'package_categories',
        {
            name: {
                type: DataTypes.STRING,
                allowNull: false,
            },
            info: {
                type: DataTypes.TEXT,
                allowNull: true,
            },
            status: {
                type: DataTypes.INTEGER,
                defaultValue: 1,
            },
            icon: {
                type: DataTypes.TEXT,
                allowNull: true,
            },
            multi_time_subscription: {
                type: DataTypes.INTEGER,
                defaultValue: 0,
            },
        },

        {
            freezeTableName: true,
            tableName: 'package_categories',
        }
    );

    return packageCat;
};

