module.exports = (sequelize, DataTypes) => {
    const mediaGallery = sequelize.define(
        'media_gallery',
        {
            title: {
                type: DataTypes.STRING,
            },
            image: {
                type: DataTypes.STRING,
            },
            description: {
                type: DataTypes.TEXT,
            },
            associate_group: {
                type: DataTypes.STRING,
            },
            album_id: {
                type: DataTypes.INTEGER,
            },

            status: {
                type: DataTypes.INTEGER,
                defaultValue: 1,
            },
        },

        {
            freezeTableName: true,
        }
    );

    return mediaGallery;
};
