module.exports = (sequelize, DataTypes) => {
    const donation = sequelize.define('donations', {
        user_id: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        f_name: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        l_name: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        mobile: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        email: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        donation_amount: {
            type: DataTypes.DECIMAL(10, 2),
            allowNull: false,
        },
        currency: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        campeign_id: {
            type: DataTypes.INTEGER,
            allowNull: false,
        },
        payment_id: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        payment_tran_id: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        donation_date: {
            type: DataTypes.DATE,
            defaultValue: DataTypes.NOW,
        },
        status: {
            type: DataTypes.INTEGER,
            defaultValue: 1,
        },
    });
    return donation;
};
