const { Op } = require('sequelize');
const db = require('../../../../config/database.config');
const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');

const { donation: DonationModel } = db.model;

exports.getUserDonationData = async (req, res) => {
    try {
        const { user } = req;

        const donationData = await DonationModel.findAll({
            where: {
                [Op.or]: [
                    {
                        user_id: user.id,
                    },
                    {
                        mobile: user.mobile,
                    },
                ],
            },
        });

        return successResponse(200, 'OK', donationData, res);
    } catch (err) {
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while getting user donation',
            res
        );
    }
};
