const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const ContactMessageModel = db.model.contract_messages;

exports.create = async (req, res) => {
    try {
        const { name, email, phone, message, subject } = req.body;

        const result = await ContactMessageModel.create({
            name,
            email,
            phone,
            message,
            subject,
        });

        if (!result) {
            return errorResponse(404, 'FAILED', 'Failed to create contact Message', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

exports.getAll = async (_, res) => {
    try {
        const result = await ContactMessageModel.findAll();

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;
        const result = await ContactMessageModel.findOne({
            where: {
                id,
            },
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO  data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;

        const isExist = await ContactMessageModel.findByPk(id);

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No data found with this id', res);
        }

        const { name, email, phone, message, subject } = req.body;

        const result = await ContactMessageModel.update(
            {
                name,
                email,
                phone,
                message,
                subject,
            },
            {
                where: {
                    id,
                },
            }
        );

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Failed to update contact message', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete heroSection

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await ContactMessageModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'contact message modal deleted failed', res);
        }

        return successResponse(204, 'OK', 'Contact Us deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
