require('dotenv').config();
const jwt = require('jsonwebtoken');
const bcrypt = require('bcryptjs');
const axios = require('axios');
const db = require('../../../../config/database.config');
const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');
const { generateCodeAndToken } = require('./generateCodeAndToken');

const User = db.model.user;
const Role = db.model.role;
const RolePermission = db.model.rolePermission;

exports.signin = async (req, res) => {
    try {
        const { mobile, rememberMe, password } = req.body;
        console.log(mobile);

        if (!mobile) {
            return errorResponse(400, 'FAILED', 'Content can not be empty!', res);
        }
        const user = await User.findOne({
            where: { mobile },
            // include: [
            //     {
            //         model: Role,
            //         attributes: ['name', 'info'],
            //     },
            // ],
        });
        if (!user) {
            return errorResponse(404, 'NOT FOUND', 'User not found', res);
        }
        // const passwordIsValid = bcrypt.compareSync(user.password, password);
        //
        // if (!passwordIsValid) {
        //     return errorResponse(400, 'FAILED', 'Invalid Password', res);
        // }
        //
        // const rolePermissionsQuery = await RolePermission.findAll({
        //     where: {
        //         role_id: user.role_id,
        //     },
        //     attributes: ['module_id', 'activity_id'],
        // });
        //
        // const userQueryData = {
        //     userQuery: user,
        //     permissions: rolePermissionsQuery,
        // };
        // const msg = await twilioClient.messages.create({
        //     body: `Your verification code is ${uniqueNumber}`,
        //     from: twilioNumber,
        //     to: '+8801303694937',
        // });
        //

        const { token, code } = generateCodeAndToken(user.mobile);
        console.log('code', code);

        const message = `Dear ${user.f_name}, Your verification code is ${code}`;

        const sms = await axios.post(
            `https://api.greenweb.com.bd/api.php?token=${process.env.SMS_API_TOKEN}&to=${mobile}&message=${message}`
        );

        return successResponse(201, 'OK', { token }, res);
    } catch (err) {
        errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while creating the User.',
            res
        );
    }
};
