const albumRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const albumController = require('../controllers/album.controller');

module.exports = (app) => {
    albumRouter.post('/', websiteImageUpload, albumController.create);

    // get all

    albumRouter.get('/', albumController.getAll);

    // get one event with id

    albumRouter.get('/:id', albumController.getOne);

    // get active data

    albumRouter.get('/active/media-gallery', albumController.getActiveData);

    // get media gallery by album id

    albumRouter.get('/active/media-gallery/:id', albumController.getActiveDataById);

    // update

    albumRouter.put('/:id', websiteImageUpload, albumController.update);

    // delete

    albumRouter.delete('/:id', albumController.delete);

    app.use('/api/album', albumRouter);
};
