const CEO_MessageRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const CEO_MessageController = require('../controllers/CEOMessage.controller');

module.exports = (app) => {
    CEO_MessageRouter.post('/', websiteImageUpload, CEO_MessageController.create);

    // get all

    CEO_MessageRouter.get('/', CEO_MessageController.getAll);

    /// get one

    CEO_MessageRouter.get('/:id', CEO_MessageController.getOne);

    // get active data

    CEO_MessageRouter.get('/getData/active', CEO_MessageController.getActiveData);

    // update

    CEO_MessageRouter.put('/:id', websiteImageUpload, CEO_MessageController.update);

    // delete

    CEO_MessageRouter.delete('/:id', CEO_MessageController.delete);

    app.use('/api/ceo-message', CEO_MessageRouter);
};
