const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const CEO_MessageModel = db.model.CEO_messages;

exports.create = async (req, res) => {
    try {
        const { name, title, status, message } = req.body;
        const { files } = req;

        const image = files?.find((file) => file?.fieldname === 'image')?.filename;

        const serviceData = {
            name,
            title,
            image,
            message,
            status,
        };

        const result = await CEO_MessageModel.create(serviceData);

        if (!result) {
            return errorResponse(404, 'FAILED', 'CEO Message created failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await CEO_MessageModel.findAll();

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;
        const result = await CEO_MessageModel.findOne({
            where: {
                id,
            },
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await CEO_MessageModel.findOne({
            where: {
                status: 1,
            },
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const isExist = await CEO_MessageModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        const { name, title, status, message } = req.body;
        const { files } = req;

        const image = files?.find((file) => file?.fieldname === 'image')?.filename;

        const serviceData = {
            name,
            title,
            image,
            message,
            status,
        };

        const result = await CEO_MessageModel.update(serviceData, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Ceo Message update failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await CEO_MessageModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Hero section modal deleted failed', res);
        }

        return successResponse(204, 'OK', 'Hero section deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
