const bcrypt = require('bcryptjs');
const errorResponse = require('../../../utils/errorResponse');
const successResponse = require('../../../utils/successResponse');

const db = require('../../../config/database.config');

const User = db.model.user;
const UserDetails = db.model.user_details;
const ShippingAddress = db.model.customer_shipping_address;

exports.signup = async (req, res) => {
    console.log(req.body);
    try {
        const { user_details, shipping, ...userData } = req.body;

        if (!userData) {
            errorResponse(400, 'FAILED', 'Content can not be empty!', res);
        }
        const isExist = await User.findOne({ where: { email: userData.email } });

        if (isExist) {
            return errorResponse(404, 'FAILED', 'User exist with this Email ', res);
        }

        const userObjData = {
            role_id: userData?.role_id,
            f_name: userData?.f_name,
            mobile: userData?.mobile,
            password: bcrypt.hashSync(userData.password, 8),
            email: userData?.email,
            address: userData?.address,
            image: userData?.image,
            signature: userData?.signature,
            status: userData?.status,
            company_name: userData?.company_name,
            previous_due: userData?.previous_due,
            created_by: userData?.created_by,
        };

        // res.send(dataObj)

        const userCreatedData = await User.create(userObjData);
        // console.log(userCreatedData);

        if (!userCreatedData) {
            return errorResponse(404, 'FAILED', 'User Create failed', res);
        }

        const { id } = userCreatedData;

        if (user_details) {
            const userDetailsData = {
                user_id: id,
                country_id: user_details?.country_id,
                state_id: user_details?.state_id,
                city_id: user_details?.city_id,
                postal_code: user_details?.postal_code,
                TIN_no: user_details?.TIN_no,
                BIN_no: user_details?.BIN_no,
                group_name: user_details?.group_name,
            };
            await UserDetails.create(userDetailsData);
        }

        if (shipping && userCreatedData?.role_id === 12) {
            // role_id 12 is customer
            const shippingAddressData = {
                user_id: id,
                f_name: shipping?.f_name,
                email: shipping?.email,
                mobile: shipping?.mobile,
                country_id: shipping?.country_id,
                state_id: shipping?.state_id,
                city_id: shipping?.city_id,
                address: shipping?.address,
                postal_code: shipping?.postal_code,
            };

            await ShippingAddress.create(shippingAddressData);
        }

        return successResponse(201, 'OK', userCreatedData, res);

        // successResponse(201, 'OK', data, res);
    } catch (err) {
        console.log(err);
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while creating the User.',
            res
        );
    }
};
