module.exports = (sequelize, DataTypes, db) => {
    db.menuItems.hasMany(db.menuItems, {
        foreignKey: 'parent_menu_id',
        as: 'subMenuItems', // alias for the association
    });

    db.menuGroup.hasMany(db.menuItems, {
        foreignKey: 'menu_group_id',
    });

    db.footer.hasMany(db.social_icon_list, {
        foreignKey: 'footer_id',
    });

    db.footer.hasMany(db.quick_link, {
        foreignKey: 'footer_id',
    });

    db.footer.hasMany(db.footer_bottom_bar, {
        foreignKey: 'footer_id',
    });

    db.job_list.hasOne(db.gender, {
        foreignKey: 'id',
        sourceKey: 'gender',
        as: 'genderInfo',
    });

    db.team_members.hasMany(db.social_icon_list, {
        foreignKey: 'member_id',
    });

    db.job_list.hasOne(db.country, {
        foreignKey: 'id',
        sourceKey: 'location',
        as: 'locationInfo',
    });

    db.job_list.hasMany(db.job_request, {
        foreignKey: 'job_id',
    });

    // db.blogs.hasMany(db.blogCategory, {
    //   foreignKey: "id",
    //   sourceKey: "blog_cat",
    //   as: "blog_category",
    // });

    db.blogCategory.hasMany(db.blogs, {
        foreignKey: 'blog_cat',
        sourceKey: 'id',
        as: 'blog_list',
    });

    // page and left page

    db.pages.hasMany(db.left_menu_page, {
        foreignKey: 'page_id',
        as: 'left_menu',
    });

    db.album.hasMany(db.media_gallery, {
        foreignKey: 'album_id',
        // as: 'media_gallery',
    });

    // subscription and user

    // user and subscription relation
    db.userSubscription.belongsTo(db.user, {
        as: 'user_info',
        foreignKey: {
            name: 'user_id',
        },
    });

    db.user.hasMany(db.userSubscription, {
        foreignKey: 'user_id',
    });

    // subscription and package relation
    db.userSubscription.hasOne(db.package, {
        as: 'package',
        foreignKey: {
            name: 'id',
        },
        sourceKey: 'package_id',
    });

    // course and course registratoin relation

    db.courseRegistration.belongsTo(db.courses, {
        foreignKey: 'course_id',
        targetKey: 'id',
    });

    db.courses.hasMany(db.courseRegistration, {
        foreignKey: 'course_id',
    });

    return db;
};
