module.exports = (sequelize, DataTypes) => {
    // Register all the models in here.........

    const db = {};

    // old -------------------------------------------------------------------------------------------------------------------------------------

    db.role = require('../modules/roles/models/role.model')(sequelize, DataTypes);
    db.user = require('../modules/users/models/user.model')(sequelize, DataTypes);
    db.user_details = require('../modules/users/models/userDetails.model')(sequelize, DataTypes);

    db.user.hasOne(db.user_details, {
        foreignKey: 'user_id',
    });

    // ===== Role & User Relationship ===== //
    db.role.hasMany(db.user, {
        foreignKey: {
            name: 'role_id',
        },
    });

    db.user.belongsTo(db.role, {
        foreignKey: {
            name: 'role_id',
        },
    });
    // ===== End Role & User ===== //

    db.activity = require('../modules/activities/models/activity.model')(sequelize, DataTypes);
    db.module = require('../modules/modules/models/module.model')(
        sequelize,

        DataTypes
    );
    db.moduleToActivity = require('../modules/moduleToActivity/models/moduleToActivity.model')(
        sequelize,
        DataTypes
    );

    // ===== Start Activity & Module Relationship ===== //

    db.activity.belongsToMany(db.module, {
        through: 'module_to_activity',
        as: 'modules',
        foreignKey: 'activity_id',
    });
    db.module.belongsToMany(db.activity, {
        through: 'module_to_activity',
        as: 'activities',
        foreignKey: 'module_id',
    });

    // ===== End Activity & Module Relationship ===== //

    db.systemSetting = require('../modules/systemSettings/models/setting.model')(
        sequelize,
        DataTypes
    );
    db.rolePermission = require('../modules/rolePermission/models/rolepermission.model')(
        sequelize,
        DataTypes
    );

    db.user.hasMany(db.rolePermission, {
        foreignKey: 'role_id',
        sourceKey: 'role_id',
        as: 'permissions',
    });

    db.gender = require('../modules/genderManagement/models/genderManagement.model')(
        sequelize,
        DataTypes
    );

    db.profession = require('../modules/professionManagement/models/profession.model')(
        sequelize,
        DataTypes
    );

    db.merital = require('../modules/maritialStatus/models/maritialstatus.model')(
        sequelize,
        DataTypes
    );

    db.country = require('../modules/country/models/country.model')(sequelize, DataTypes);
    db.state = require('../modules/states/models/state.model')(sequelize, DataTypes);
    db.city = require('../modules/cities/models/city.model')(sequelize, DataTypes);

    // ===== Start Country & State Relationship ===== //
    db.country.hasMany(db.state, {
        foreignKey: {
            name: 'country_id',
        },
    });
    db.state.belongsTo(db.country, {
        foreignKey: {
            name: 'country_id',
        },
    });
    // ===== End Country & State Relationship ===== //

    // ===== Start City & State Relationship ===== //
    db.state.hasMany(db.city, {
        foreignKey: {
            name: 'state_id',
        },
    });
    db.city.belongsTo(db.state, {
        foreignKey: {
            name: 'state_id',
        },
    });
    // ===== End City & State Relationship ===== //

    db.uom = require('../modules/uom/models/uom.model')(sequelize, DataTypes);
    db.instrument = require('../modules/instrumentManagement/models/instrument.model')(
        sequelize,
        DataTypes
    );

    // ===== Start uom & instruments Relationship ===== //
    db.uom.hasMany(db.instrument, {
        foreignKey: {
            name: 'unit_id',
        },
    });
    db.instrument.belongsTo(db.uom, {
        foreignKey: {
            name: 'unit_id',
        },
    });
    // ===== End uom & instruments Relationship ===== //

    db.instrumentCategory =
        require('../modules/instrumentsCategory/models/instrumentsCategory.model')(
            sequelize,
            DataTypes
        );

    // ===== Start InstrumentCategory & Instrument Relationship ===== //
    db.instrumentCategory.hasMany(db.instrument, {
        foreignKey: {
            name: 'cat_id',
        },
    });
    db.instrument.belongsTo(db.instrumentCategory, {
        foreignKey: {
            name: 'cat_id',
        },
    });

    // ===== End InstrumentCategory & Instrument Relationship ===== //

    db.staticContentGroup =
        require('../modules/staticContentGroups/models/staticContentGroup.model')(
            sequelize,
            DataTypes
        );
    db.staticContent = require('../modules/staticContents/models/staticContent.model')(
        sequelize,
        DataTypes
    );

    // ======= Start staticContentGroups & staticContents relationships ========= //
    db.staticContentGroup.hasMany(db.staticContent, {
        foreignKey: {
            name: 'static_content_group_id',
        },
    });
    db.staticContent.belongsTo(db.staticContentGroup, {
        foreignKey: {
            name: 'static_content_group_id',
        },
    });

    // ======= End staticContentGroups & staticContents ========= //
    // ===== Start headIdentifier & headGroup Relationship ===== //
    /// // ================== menu Groups =============================

    db.menuGroup = require('../modules/Appearance/MenuGroup/models/menuGroup.model')(
        sequelize,
        DataTypes
    );

    // ================== menu items =============================

    db.menuItems = require('../modules/Appearance/MenuItems/models/menuItems.model')(
        sequelize,
        DataTypes
    );

    // ======================= website pannel ==================

    // ===================== hero section ===================

    db.heroSection = require('../modules/websites/heroSection/models/heroSection.model')(
        sequelize,
        DataTypes
    );

    // ===============about us ===============

    db.about_us = require('../modules/websites/aboutUs/models/aboutUs.model')(sequelize, DataTypes);

    //= ============== our serivices ==========================

    db.our_services = require('../modules/websites/ourService/models/ourService.model')(
        sequelize,
        DataTypes
    );

    db.why_choose_us = require('../modules/websites/whyChooseUs/models/whyChooseUs.model')(
        sequelize,
        DataTypes
    );

    // destination

    db.destination = require('../modules/websites/destination/models/destination.model')(
        sequelize,
        DataTypes
    );

    // tour-type

    db.tourType = require('../modules/websites/tourType/models/tourType.model')(
        sequelize,
        DataTypes
    );

    // messageManagement

    db.messageManagement = require('../modules/websites/messageManagement/models/messageManagement.model')(
        sequelize,
        DataTypes
    );
    // corporate-logo

    db.corporateLogo = require('../modules/websites/corporateLogo/models/corporateLogo.model')(
        sequelize,
        DataTypes
    );

    // welcome_message

    db.welcome_message = require('../modules/websites/welcome_message/models/welcome_message.model')(
        sequelize,
        DataTypes
    );

    // visa

    db.visa = require('../modules/websites/visa/models/visa.model')(
        sequelize,
        DataTypes
    );
    
    // visa

    db.visa_type = require('../modules/websites/visa_type/models/visa_type.model')(
        sequelize,
        DataTypes
    );

    // visa_required_documents Model 

    db.visa_required_documents = require('../modules/websites/visa/models/visa_required_documents.model')(
        sequelize,
        DataTypes
    );

    // visa_faq Model

    // db.visa_faq = require('../modules/websites/visa/models/visa_faq.model')(
    //     sequelize,
    //     DataTypes
    // );

    // offer

    db.offer = require('../modules/websites/offer/models/offer.model')(
        sequelize,
        DataTypes
    );

    // testimonial

    db.testimonial = require('../modules/websites/testimonial/models/testimonial.model')(
        sequelize,
        DataTypes
    );

    // booking

    db.booking = require('../modules/websites/booking/models/booking.model')(sequelize, DataTypes);

    // banner

    db.banner = require('../modules/websites/banner/models/banner.model')(sequelize, DataTypes);

    // travelCategory

    db.travelCategory = require('../modules/websites/travelCategory/models/travelCategory.model')(
        sequelize,
        DataTypes
    );

    // state counter
    db.stat_counter = require('../modules/websites/statCounter/models/statCounter.model')(
        sequelize,
        DataTypes
    );
    // blogs

    db.blogs = require('../modules/websites/blogs/models/blogs.model')(sequelize, DataTypes);

    // blog category

    db.blogCategory = require('../modules/websites/blogCategory/model/blogCat.model')(
        sequelize,
        DataTypes
    );

    // media gallery

    db.media_gallery = require('../modules/websites/mediaGallery/models/mediaGallery.model')(
        sequelize,
        DataTypes
    );

    // ======== footer ===========
    db.footer = require('../modules/websites/footer/models/footer.model')(sequelize, DataTypes);

    // ========= quick link list

    db.quick_link = require('../modules/websites/footer/models/quickLink.model')(
        sequelize,
        DataTypes
    );

    // ========= icon list with link ==========

    db.social_icon_list = require('../modules/websites/footer/models/socialMediaIcon.model')(
        sequelize,
        DataTypes
    );

    db.footer_bottom_bar = require('../modules/websites/footer/models/footerBottomBar')(
        sequelize,
        DataTypes
    );

    db.job_list = require('../modules/websites/jobList/models/jobList.model')(sequelize, DataTypes);

    // contact us page

    db.contact_us = require('../modules/websites/contactPage/models/contact.model')(
        sequelize,
        DataTypes
    );
    
    // newsletterSubscription

    db.newsletterSubscription = require('../modules/websites/newsletterSubscription/models/newsletterSubscription.model')(
        sequelize,
        DataTypes
    );
    
    // popupform

    db.popupform = require('../modules/websites/popupform/models/popupform.model')(
        sequelize,
        DataTypes
    );

    // conract message

    db.contract_messages =
        require('../modules/websites/contactMessage/models/contactMessage.model')(
            sequelize,
            DataTypes
        );

    // team members

    db.team_members = require('../modules/websites/teamMember/models/teamMember.model')(
        sequelize,
        DataTypes
    );

    db.team_members.hasMany(db.social_icon_list, {
        foreignKey: 'memeber_id',
    });

    // ceo message

    db.CEO_messages = require('../modules/websites/CEOMessage/models/CEOMessage.model')(
        sequelize,
        DataTypes
    );

    // mission vision motto

    db.mission_vision_motto =
        require('../modules/websites/MissonVisionMotto/models/MissionVissionMotto.model')(
            sequelize,
            DataTypes
        );

    db.job_request = require('../modules/websites/jobRequest/models/jobRequest.model')(
        sequelize,
        DataTypes
    );

    // pages

    db.pages = require('../modules/websites/pages/models/pages.model')(sequelize, DataTypes);

    db.left_menu_page = require('../modules/websites/pages/models/leftMenuPage.model')(
        sequelize,
        DataTypes
    );

    // mosque list

    db.mosque_list = require('../modules/websites/mosqueList/models/mosqueList.model')(
        sequelize,
        DataTypes
    );

    // events category

    db.event_category = require('../modules/websites/eventCategory/model/eventCat.model')(
        sequelize,
        DataTypes
    );

    // events

    db.events = require('../modules/websites/events/models/events.model')(sequelize, DataTypes);

    // package

    // Start Package //

    // package category
    db.packageCategory = require('../modules/websites/packageCategory/models/packageCat.models')(
        sequelize,
        DataTypes
    );
    // package category
    db.travelCategory = require('../modules/websites/travelCategory/models/travelCategory.model')(
        sequelize,
        DataTypes
    );
    db.package = require('../modules/websites/package/models/package.model')(sequelize, DataTypes);
    
    db.packageMonth = require('../modules/websites/package/models/packageMonth.model')(sequelize, DataTypes);

    db.month = require('../modules/websites/package/models/monthModel.model')(sequelize, DataTypes);

    db.facility = require('../modules/websites/facility/models/facility.model')(
        sequelize,
        DataTypes
    );

    db.packageIncluded = require('../modules/websites/package/models/packageIncluded.model')(
        sequelize,
        DataTypes
    );
    db.packageExcluded = require('../modules/websites/package/models/packageExcluded.model')(
        sequelize,
        DataTypes
    );
    db.packageItinerary = require('../modules/websites/package/models/packageItinerary.model')(
        sequelize,
        DataTypes
    );
    db.packagePoints = require('../modules/websites/package/models/packagePoints.model')(
        sequelize,
        DataTypes
    );
    
    db.PackageFacilities = require('../modules/websites/package/models/packageFacility.model')(
        sequelize,
        DataTypes
    );

    db.packageFeature = require('../modules/websites/package/models/packageIncluded.model')(
        sequelize,
        DataTypes
    );
    // db.package.hasMany(db.packageFeature, {
    //     foreignKey: {
    //         name: 'package_id',
    //     },
    // });
    db.packageFeature.belongsTo(db.package, {
        foreignKey: {
            name: 'package_id',
        },
    });

    // relation between package and package id

    // db.package.belongsTo(db.PackageCategory, {
    // foreignKey: 'package_cat_id',
    //     targetKey: 'id',
    //     as: 'packageCat',
    // });

    // End Package //

    // courses

    db.courseCategory = require('../modules/websites/courseCategory/model/courseCat.model')(
        sequelize,
        DataTypes
    );
    db.courses = require('../modules/websites/courses/model/courses.model')(sequelize, DataTypes);
    db.courses.hasMany(db.courseCategory, {
        foreignKey: {
            name: 'course_cat_id',
        },
    });

    db.courses.hasOne(db.user, {
        foreignKey: 'id',
        sourceKey: 'instructor_id',
        as: 'instructor',
    });

    // campeigns

    db.campeigns = require('../modules/websites/campeigns/models/campeigns.model')(
        sequelize,
        DataTypes
    );

    // campeign category

    db.campeignCategory = require('../modules/websites/campeignCategory/model/CampeignCat.model')(
        sequelize,
        DataTypes
    );

    // album

    db.album = require('../modules/websites/album/model/album.model')(sequelize, DataTypes);

    // albumVideo

    db.albumVideo = require('../modules/websites/albumVideo/model/albumVideo.model')(sequelize, DataTypes);
    
    // video

    db.video = require('../modules/websites/video/models/video.model')(sequelize, DataTypes);

    // user payment

    db.user_payment = require('../modules/websites/payment/models/payment.model')(
        sequelize,
        DataTypes
    );

    db.userSubscription = require('../modules/websites/subscriptions/model/subscription.model')(
        sequelize,
        DataTypes
    );

    // donation model

    db.donation = require('../modules/websites/donation/models/donation.model')(
        sequelize,
        DataTypes
    );

    // course Register table
    db.courseRegistration =
        require('../modules/websites/courseRegistration/models/courseReg.model')(
            sequelize,
            DataTypes
        );

    // audio surah

    db.audioSurah = require('../modules/websites/audioSurah/models/audioSurah.model')(
        sequelize,
        DataTypes
    );

    // Correct association
    db.blogCategory.hasMany(db.blogs, {
        foreignKey: 'blog_cat', // Reference to blog_cat in blogs table
        sourceKey: 'id',        // Reference to id in blog_category table
        as: 'blogs',            // Alias for the blogs associated with a category
    });
    
    // albumVideo
    db.albumVideo.hasMany(db.video, {
        foreignKey: 'album', // Reference to blog_cat in blogs table
        sourceKey: 'id',        // Reference to id in blog_category table
        as: 'videos',            // Alias for the blogs associated with a category
    });

    db.blogs.belongsTo(db.blogCategory, {
        foreignKey: 'blog_cat', // Reference to blog_cat in blogs table
        targetKey: 'id',        // Reference to id in blog_category table
        as: 'category',         // Alias for the category associated with a blog
    });

    // db.blogCategory.hasMany(db.blogs, {
    //     foreignKey: 'id',
    //     sourceKey: 'blogs_id',
    //     as: 'blogs',
    // });

    // db.blogs.belongsTo(db.blogCategory, {
    //     foreignKey: 'id',
    //     sourceKey: 'blog_cat',
    //     as: 'blogs',
    // });

    // db.blogs.belongsTo(db.blogCategory, {
    //     foreignKey: {
    //         name: 'blog_category_id',
    //     },
    // });

    // db.blogs.belongsTo(db.blogCategory, {
    //     foreignKey: 'blog_category_id',
    //     as: 'blogByCategoryId',
    // });

    // 1:m included
    // db.package.hasMany(db.packageIncluded, {
    //     foreignKey: {
    //         name: 'included_id',
    //     },
    // });

    db.package.belongsTo(db.travelCategory, {
        foreignKey: 'travelCategoryId',
        targetKey: 'id',
        as: 'travelCategory',
    });

    db.travelCategory.hasMany(db.package, {
        foreignKey: 'travelCategoryId',
        sourceKey: 'id',
        as: 'package',
    });

    // // 1:m included
    db.tourType.hasMany(db.package, {
        foreignKey: 'tourTypeId',
        sourceKey: 'id',
        as: 'package',
    });
    
    

    db.package.belongsTo(db.tourType, {
        foreignKey: 'tourTypeId', // tourType, package table er moddhe kon name ase? ans: `tourTypeld`
        targetKey: 'id', // kar sathe tourType ta connected? ans: package er `id`
        as: 'tourType', // res e ei field ta ki name dekhabe? and: `tourType`
    });

    db.package.belongsTo(db.destination, {
        foreignKey: 'destination_id', // tourType, package table er moddhe kon name ase? ans: `tourTypeld`
        targetKey: 'id', // kar sathe tourType ta connected? ans: package er `id`
        as: 'destination', // res e ei field ta ki name dekhabe? and: `tourType`
    });

    db.package.hasMany(db.packageMonth, {
        foreignKey: 'package_id',
        sourceKey: 'id',
        // as: 'months',
    });
    
    db.month.hasMany(db.packageMonth, {
        foreignKey: 'month_id',
        sourceKey: 'id',
        // as: 'months',
    });
    
    db.packageMonth.belongsTo(db.package, {
        foreignKey: 'package_id',
        targetKey: 'id',
        // as: 'destination',
    });
    
    db.packageMonth.belongsTo(db.month, {
        foreignKey: 'month_id',
        targetKey: 'id',
        // as: 'destination',
    });

    db.package.hasMany(db.packageIncluded, {
        foreignKey: 'package_id',
        sourceKey: 'id',
        as: 'includes',
    });

    db.package.hasMany(db.packageExcluded, {
        foreignKey: 'package_id',
        sourceKey: 'id',
        as: 'excludes',
    });

    db.package.hasMany(db.packageItinerary, {
        foreignKey: 'package_id',
        sourceKey: 'id',
        as: 'itineraries',
    });

    db.package.hasMany(db.packagePoints, {
        foreignKey: 'package_id',
        sourceKey: 'id',
        as: 'points',
    });
    
    db.package.hasMany(db.PackageFacilities, {
        foreignKey: 'package_id',
        sourceKey: 'id',
        as: 'package_facilities',
    });
    
    db.PackageFacilities.hasOne(db.facility, {
        foreignKey: 'id',
        sourceKey: 'value',
        // as: 'package_facilities',
    });
    // db.facility.hasMany(db.PackageFacilities, {
    //     foreignKey: 'value',
    //     sourceKey: 'id',
    //     as: 'package_facilities',
    // });

    // db.PackageFacilities.belongsTo(db.package, {
    //     foreignKey: 'package_id',
    //     targetKey: 'id',
    //     // as: 'destination',
    // });
    
    // db.PackageFacilities.belongsTo(db.facility, {
    //     foreignKey: 'value',
    //     targetKey: 'id',
    //     // as: 'destination',
    // });

    db.destination.hasMany(db.package, {
        foreignKey: 'destination_id', 
        sourceKey: 'id',
        as: 'package',
    });

    db.visa_type.hasMany(db.visa, {
        foreignKey: 'visa_type_id',
        sourceKey: 'id',
        as: 'visa',
    });

    db.visa.belongsTo(db.visa_type, {
        foreignKey: 'visa_type_id',
        targetKey: 'id',
        as: 'visa_type',
    });
    
    db.visa.belongsTo(db.destination, {
        foreignKey: 'destination_id',
        targetKey: 'id',
        as: 'destination',
    });

    db.destination.hasMany(db.visa, {
        foreignKey: 'destination_id',
        sourceKey: 'id',
        as: 'visa',
    });
    
    // album
    
    db.album.hasMany(db.media_gallery, {
        foreignKey: 'album_id',
        sourceKey: 'id',
        as: 'media_gallery',
    });

    // db.visa.belongsTo(db.destination, {
    //     foreignKey: 'destination_id',
    //     targetKey: 'id',
    //     as: 'destination',
    // });


    // db.visa.hasMany(db.visa_required_documents, {
    //     foreignKey: 'visa_id',
    //     sourceKey: 'id',
    //     as: 'visa_required_documents',
    // });

    // db.visa.hasMany(db.visa_faq, {
    //     foreignKey: 'visa_id',
    //     sourceKey: 'id',
    //     as: 'visa_faq',
    // });

    // db.visa.hasMany(db.visa_faq, {
    //     foreignKey: 'visa_id', // visa_id is a filed of `visa_faq` table as foreignKey of `visa` table
    //     sourceKey: 'id', // id is a filed of `visa` table and primaryKey
    //     as: 'visa_faq', // `visa_faq` table will be show as the field name `visa_faq` when `visa` table will be requested from db 
    // });

    // db.packageIncluded.belongsTo(db.package, {
    //     foreignKey: 'package_id',
    //     targetKey: 'id',
    //     as: 'package',
    // });

    // db.packageExcluded.belongsTo(db.package, {
    //     foreignKey: 'package_id',
    //     targetKey: 'id',
    //     as: 'package',
    // });

    // db.packageItinerary.belongsTo(db.package, {
    //     foreignKey: 'package_id',
    //     targetKey: 'id',
    //     as: 'package',
    // });

    // db.packagePoints.belongsTo(db.package, {
    //     foreignKey: 'package_id',
    //     targetKey: 'id',
    //     as: 'package',
    // });


    require('./secondModel.config')(sequelize, DataTypes, db);

    return db;
};
