const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const welcome_message_model = db.model.welcome_message;

exports.create = async (req, res) => {
    try {
        const {
            name,
            btn_name,
            btn_link,
            status,
        } = req.body;
        // const { files } = req;

        // const image = files?.find((file) => file?.fieldname === 'image').filename;

        console.log("dataObject welcome msg req.body: ", req.body)
        const dataObject = {
            name,
            btn_name,
            btn_link,
            status,

        };
        console.log("dataObject welcome msg: ", dataObject)
        const result = await welcome_message_model.create(dataObject);

        if (!result) {
            return errorResponse(404, 'FAILED', 'Welcome Message created failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await welcome_message_model.findAll({
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await welcome_message_model.findOne({
            where: {
                id,
            },
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await welcome_message_model.findAll({
            where: {
                status: 1,
            },
        });
        console.log("result", result)

        if (result.length === 0) {
            // return res;
            return successResponse(200, 'OK', result, res);
            // return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }
        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server-side error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const {
            name,
            btn_name,
            btn_link,
            status,
        } = req.body;
        // const { files } = req;

        console.log(req.body);

        const isExist = await welcome_message_model.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        // const image =
        //     files?.find((file) => file?.fieldname === 'image')?.filename ||
        //     isExist?.image;

        const dataObject = {
            name,
            btn_name,
            btn_link,
            status,

        };

        const result = await welcome_message_model.update(dataObject, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Welcome Message created failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await welcome_message_model.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Welcome Message deleted failed', res);
        }

        return successResponse(204, 'OK', 'Welcome Message deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
