const visa_faqRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const visa_faqController = require('../controller/visa_faq.controller');

module.exports = (app) => {
    visa_faqRouter.post('/', websiteImageUpload, visa_faqController.create);

    // get all

    visa_faqRouter.get('/', visa_faqController.getAll);

    // get active data

    visa_faqRouter.get('/active', visa_faqController.getActiveData);

    // get one

    visa_faqRouter.get('/:id', visa_faqController.getOne);

    // update

    visa_faqRouter.put('/:id', visa_faqController.update);

    // delete

    visa_faqRouter.delete('/:id', visa_faqController.delete);

    app.use('/api/visa_type', visa_faqRouter);
};
