const videoRouter = require('express').Router();
const videoController = require('../controllers/video.controller');

module.exports = (app) => {
    videoRouter.post('/', videoController.create);

    // get all

    videoRouter.get('/', videoController.getAll);

    // get active data

    videoRouter.get('/active', videoController.getActiveData);

    // update

    videoRouter.put('/:id', videoController.update);

    // delete

    videoRouter.delete('/:id', videoController.delete);

    app.use('/api/video', videoRouter);
};
