const TourTypeRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const tourTypeController = require('../controller/tourType.controller');

module.exports = (app) => {
    TourTypeRouter.post('/', websiteImageUpload, tourTypeController.create);

    // get all

    TourTypeRouter.get('/', tourTypeController.getAll);

    // get active data

    TourTypeRouter.get('/active', tourTypeController.getActiveData);

    // get one

    TourTypeRouter.get('/:id', tourTypeController.getOne);


    // update

    TourTypeRouter.put('/:id', websiteImageUpload, tourTypeController.update);

    // delete

    TourTypeRouter.delete('/:id', tourTypeController.delete);

    app.use('/api/tourType', TourTypeRouter);
};
