const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const TestimonialModel = db.model.testimonial;
// const packageModel = db.model.package;

exports.create = async (req, res) => {
    try {
        const { name, title, message, rating, status, } = req.body;
        const { files } = req;

        const image = files?.find((file) => file?.fieldname === 'image').filename;

        const testimonialData = {
            name,
            image,
            title,
            message,
            rating,
            status,
        };
        
        const result = await TestimonialModel.create(testimonialData);
        console.log("testimonialData result 3=> ", result);

        if (!result) {
            return errorResponse(404, 'FAILED', 'Testimonial created failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await TestimonialModel.findAll({});

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await TestimonialModel.findOne({
            where: {
                id,
            },

        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await TestimonialModel.findAll({
            where: {
                status: 1,
            },

        });
        console.log("result", result)

        if (result.length === 0) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }
        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server-side error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { name, title, message, rating, status, } = req.body;
        const { files } = req;

        console.log(req.body);

        const isExist = await TestimonialModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        const image =
            files?.find((file) => file?.fieldname === 'image')?.filename ||
            isExist?.image;

        const testimonialData = {
            name,
            image,
            title,
            message,
            rating,
            status,
        };

        const result = await TestimonialModel.update(testimonialData, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Testimonial created failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await TestimonialModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Testimonial deleted failed', res);
        }

        return successResponse(204, 'OK', 'Testimonial deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
