const errorResponse = require("../../../../utils/errorResponse");
const successResponse = require("../../../../utils/successResponse");
// const { TeamMembersModel, SocialIconModel } = require(".");
const { model } = require("../../../../config/database.config");

const { team_members: TeamMembersModel, social_icon_list: SocialIconModel } =
  model;

exports.getOne = async (req, res) => {
  try {
    const { id } = req.params;
    const result = await TeamMembersModel.findOne({
      where: {
        id,
      },
      include: [
        {
          model: SocialIconModel,
        },
      ],
    });

    return successResponse(200, "OK", result, res);
  } catch (error) {
    return errorResponse(
      500,
      "ERROR",
      error.message || "There is a server side problem",
      res,
    );
  }
};
