const popupFormRouter = require('express').Router();
const popupFormController = require('../controllers/popupform.controller');

module.exports = (app) => {
    popupFormRouter.post('/', popupFormController.create);

    // get all the data

    popupFormRouter.get('/', popupFormController.getAll);

    // get active data

    popupFormRouter.get('/getData/active', popupFormController.getActiveData);

    // get one data

    popupFormRouter.get('/:id', popupFormController.getOne);

    // update hero hero-section

    popupFormRouter.put('/:id', popupFormController.update);

    // delete hero section
    popupFormRouter.delete('/:id', popupFormController.delete);

    app.use('/api/popupform', popupFormRouter);
};
