module.exports = (sequelize, DataTypes) => {
    const UserPayment = sequelize.define('user_payment', {
        tran_date: {
            type: DataTypes.DATE,
        },
        tran_id: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        user_id: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },

        user_mobile: {
            type: DataTypes.STRING,
            allowNull: true,
        },

        account_id: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        payment_user_name: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        payment_user_email: {
            type: DataTypes.STRING,
            allowNull: true,
        },

        payment_location: {
            type: DataTypes.STRING,
            allowNull: true,
        },

        total_amount: {
            type: DataTypes.DECIMAL(11, 2),
            // allowNull: false,
        },
        store_amount: {
            type: DataTypes.DECIMAL(11, 2),
        },
        payment_fee: {
            type: DataTypes.DECIMAL(11, 2),
        },
        currency: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        payment_package_id: {
            type: DataTypes.STRING,
        },
        campeign_id: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        // payment_category_id: {
        //     type: DataTypes.INTEGER,
        // },
        // product_profile: {
        //     type: DataTypes.STRING,
        // },
        card_type: {
            type: DataTypes.STRING,
        },
        card_brand: {
            type: DataTypes.STRING,
        },
        status: {
            type: DataTypes.INTEGER,
        },
    });
    return UserPayment;
};
