const fetch = require('node-fetch');

const base = 'https://api-m.sandbox.paypal.com';
const { paypalClient, generatePaypalAccessToken } = require('./paypalConfig');

const db = require('../../../../config/database.config');
const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');

// dbs
//
// const PaymentModel = db.model.user_payment;
// const UserSubscription = db.model.userSubscription;
// const PackageModel = db.model.package;

exports.createPaypalOrderId = async (req, res) => {
    try {
        const { order_price } = req.body;

        if (!order_price) {
            return errorResponse(400, 'ERROR', 'Order price is required', res);
        }

        const accessToken = await generatePaypalAccessToken();
        const url = `${base}/v2/checkout/orders`;

        const payload = {
            intent: 'CAPTURE',
            purchase_units: [
                {
                    amount: {
                        currency_code: 'USD',
                        value: order_price || 0,
                    },
                },
            ],
        };

        const result = await fetch(url, {
            headers: {
                'Content-Type': 'application/json',
                Authorization: `Bearer ${accessToken}`,
                // Uncomment one of these to force an error for negative testing (in sandbox mode only).
                // Documentation: https://developer.paypal.com/tools/sandbox/negative-testing/request-headers/
                // "PayPal-Mock-Response": '{"mock_application_codes": "MISSING_REQUIRED_PARAMETER"}'
                // "PayPal-Mock-Response": '{"mock_application_codes": "PERMISSION_DENIED"}'
                // "PayPal-Mock-Response": '{"mock_application_codes": "INTERNAL_SERVER_ERROR"}'
            },
            method: 'POST',
            body: JSON.stringify(payload),
        });
        const parseResult = await result.json();
        console.log(parseResult);

        if (parseResult?.status !== 'CREATED') {
            return errorResponse(400, 'ERROR', 'Error occured while creating order id', res);
        }

        return successResponse(200, 'OK', parseResult, res);
    } catch (err) {
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while creating order id',
            res
        );
    }
};
