const pagesRouter = require('express').Router();

const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const pagesController = require('../controllers/page.controller');

module.exports = (app) => {
    pagesRouter.post('/upload/images', websiteImageUpload, pagesController.uploadImages);

    pagesRouter.post('/', pagesController.create);

    // get data

    pagesRouter.get('/', pagesController.getAll);
    
    // get active data

    pagesRouter.get('/', pagesController.getActiveData);

    // get single content

    pagesRouter.get('/get-content', pagesController.getContent);

    // get one

    pagesRouter.get('/get-one/:id', pagesController.getOne);

    // update

    pagesRouter.put('/:id', pagesController.update);

    // delete

    pagesRouter.delete('/:id', pagesController.delete);

    app.use('/api/pages', pagesRouter);
};
