require('dotenv').config();
// const { model } = require("mongoose");
const db = require('../../../../config/database.config');

const UserSubscription = db.model.userSubscription;
const Package = db.model.package;
const UserFile = db.model.userFile;
const FileType = db.model.fileUpType;
const User = db.model.user;
const Role = db.model.role;

const { PackageCategory } = db.model;

const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');

exports.findAll = async (req, res) => {
    try {
        const { status } = req.query;
        if (status) {
            const result = await PackageCategory.findAll({ where: { status } });
            // console.log(result)
            return successResponse(200, 'OK', result, res);
        }

        const result = await PackageCategory.findAll();
        // console.log(result)
        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(
            500,
            'ERROR',
            error.message || 'Some error occurred while fetching subscription info',
            res
        );
    }
};

exports.createPackageCat = async (req, res) => {
    try {
        const { name, icon, info, status, multi_time_subscription } = req.body;
        const result = await PackageCategory.create({
            name,
            icon,
            info,
            status,
            multi_time_subscription,
        });
        if (result) {
            successResponse(200, 'OK', result, res);
        }
    } catch (error) {
        errorResponse(
            500,
            'ERROR',
            error.message || 'Some error occurred while fetching subscription info',
            res
        );
    }
};

exports.update = async (req, res) => {
    try {
        const { id } = req.params;

        const { name, icon, info, status, multi_time_subscription } = req.body;

        const isExist = await PackageCategory.findOne({ where: { id } });

        if (!isExist) {
            return errorResponse(404, 'FAILED', 'PackageCategory not found', res);
        }

        const updatedata = {
            name,
            icon,
            info,
            status,
            multi_time_subscription,
        };

        const result = await PackageCategory.update(updatedata, { where: { id } });

        if (!result.includes(1)) {
            return successResponse(200, 'OK', 'PackageCategory update Failed', res);
        }

        return successResponse(200, 'OK', 'PackageCategory updated successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message, res);
    }
};

exports.delete = (req, res) => {
    const { id } = req.params;

    PackageCategory.destroy({
        where: { id },
    })
        .then((num) => {
            if (num == 1) {
                res.send({
                    message: 'PackageCategory was deleted successfully!',
                });
            } else {
                res.send({
                    message: `Cannot delete PackageCategory with id=${id}. Maybe PackageCategory was not found!`,
                });
            }
        })
        .catch((err) => {
            res.status(500).send({
                message: `Could not delete PackageCategory with id=${id}`,
            });
        });
};

exports.getActivePackage = async (req, res) => {
    try {
        const result = await PackageCategory.findAll({
            where: {
                status: 1,
            },
        });
        if (result) {
            successResponse(200, 'OK', result, res);
        }
    } catch (error) {
        errorResponse(
            500,
            'ERROR',
            error.message || 'Some error occurred while fetching subscription info',
            res
        );
    }
};

