module.exports = (sequelize, DataTypes) => {
    const offer = sequelize.define('offers', {
        name: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        image: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        title: {
            type: DataTypes.TEXT,
            allowNull: true,
        },
        sub_title: {
            type: DataTypes.TEXT,
            allowNull: true,
        },
        offer_percentage: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        button_text: {
            type: DataTypes.TEXT,
            allowNull: true,
        },
        button_link: {
            type: DataTypes.TEXT,
            allowNull: true,
        },
        description: {
            type: DataTypes.TEXT,
            allowNull: true,
        },
        success_count: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        status: {
            type: DataTypes.INTEGER,
            defaultValue: 1,
        },
    });

    return offer;
};
