const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const OfferModel = db.model.offer;
// const packageModel = db.model.package;

exports.create = async (req, res) => {
    try {
        const { name, title, sub_title, offer_percentage, button_text, button_link, description, success_count, status, } = req.body;
        const { files } = req;

        const image = files?.find((file) => file?.fieldname === 'image').filename;

        const offerData = {
            name,
            image,
            title,
            sub_title,
            offer_percentage,
            button_text,
            button_link,
            description,
            success_count,
            status,
        };

        console.log("offerData req body ==>", offerData)
        const result = await OfferModel.create(offerData);
        console.log("result OfferData ==>", result)

        if (!result) {
            return errorResponse(404, 'FAILED', 'Offer created failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await OfferModel.findAll();

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await OfferModel.findOne({
            where: {
                id,
            },

        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await OfferModel.findAll({
            where: {
                status: 1,
            },

        });
        console.log("result", result)

        if (result.length === 0) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }
        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server-side error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { name, title, sub_title, offer_percentage, button_text, button_link, description, success_count, status, } = req.body;
        const { files } = req;

        console.log(req.body);

        const isExist = await OfferModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        const image =
            files?.find((file) => file?.fieldname === 'image')?.filename ||
            isExist?.image;

        const offerData = {
            name,
            image,
            title,
            sub_title,
            offer_percentage,
            button_text,
            button_link,
            description,
            success_count,
            status,
        };

        const result = await OfferModel.update(offerData, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Offer created failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await OfferModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Offer deleted failed', res);
        }

        return successResponse(204, 'OK', 'Offer deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
