const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

// dbs

const { mosque_list: MosqueList } = db.model;

// delete
exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await MosqueList.destroy({
            where: {
                id,
            },
        });
        console.log(result);

        if (result !== 1) {
            return errorResponse(404, 'NOT FOUND', 'mosque delete failed', res);
        }

        return successResponse(200, 'OK', 'Deleted Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There is a server side error', res);
    }
};
