const messageManagementRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const messageManagementController = require('../controller/messageManagement.controller');

module.exports = (app) => {
    messageManagementRouter.post('/', websiteImageUpload, messageManagementController.create);

    // get all

    messageManagementRouter.get('/', messageManagementController.getAll);

    // get active data

    messageManagementRouter.get('/active', messageManagementController.getActiveData);

    // get one

    messageManagementRouter.get('/:id', messageManagementController.getOne);


    // update

    messageManagementRouter.put('/:id', websiteImageUpload, messageManagementController.update);

    // delete

    messageManagementRouter.delete('/:id', messageManagementController.delete);

    app.use('/api/messageManagement', messageManagementRouter);
};
