const mediaGalleryRouter = require('express').Router();

const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const mediaGalleryController = require('../controllers/mediaGallery.controller');

module.exports = (app) => {
    mediaGalleryRouter.post('', websiteImageUpload, mediaGalleryController.create);

    mediaGalleryRouter.get('/', mediaGalleryController.findAll);

    // get one data by id

    mediaGalleryRouter.get('/:id', mediaGalleryController.getOne);
    // find active about us data

    mediaGalleryRouter.get('/get-data/active', mediaGalleryController.findActive);

    // update about us section

    mediaGalleryRouter.put('/:id', websiteImageUpload, mediaGalleryController.update);

    // delete about us section

    mediaGalleryRouter.delete('/:id', mediaGalleryController.delete);

    app.use('/api/media-gallery', mediaGalleryRouter);
};
