const jobListRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const jobListController = require('../controllers/jobList.controller');

module.exports = (app) => {
    jobListRouter.post('/', websiteImageUpload, jobListController.create);

    // get all the data

    jobListRouter.get('/', jobListController.getAll);

    // find one

    jobListRouter.get('/:id', jobListController.getOne);

    // get active data

    jobListRouter.get('/getData/active', jobListController.getActiveData);

    // get job request of the job data

    jobListRouter.get('/job-request/:id', jobListController.getJobRequestData);

    // get location

    jobListRouter.get('/getData/get-location', jobListController.getLocationOfAllJobs);

    // update hero hero-section

    jobListRouter.put('/:id', websiteImageUpload, jobListController.update);

    // delete hero section
    jobListRouter.delete('/:id', jobListController.delete);

    app.use('/api/job-list', jobListRouter);
};
