const db = require("../../../../config/database.config");

const errorResponse = require("../../../../utils/errorResponse");

const successResponse = require("../../../../utils/successResponse");

const HeroSectionModel = db.model.heroSection;

exports.create = async (req, res) => {
  try {
    const data = req.body;

    const { files } = req;

    const heroSectionData = {
      title: data?.title,
      description: data?.description,
      banner_img: files?.find((file) => file?.fieldname === "banner_img")
        ?.filename,
      side_img: files?.find((file) => file?.fieldname === "side_img")?.filename,
      button_title: data?.button_title,
      button_link: data?.button_link,
      status: data?.status,
    };

    console.log(heroSectionData);

    const result = await HeroSectionModel.create(heroSectionData);

    if (!result) {
      return errorResponse(404, "FAILED", "Failed to create new Banner", res);
    }

    return successResponse(201, "OK", result, res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err?.message || "There is a server side problem",
      res,
    );
  }
};

exports.getAll = async (_, res) => {
  try {
    const result = await HeroSectionModel.findAll();

    return successResponse(200, "OK", result, res);
  } catch (error) {
    return errorResponse(
      500,
      "ERROR",
      error.message || "There is a server side problem",
      res,
    );
  }
};

exports.getActiveData = async (_, res) => {
  try {
    const result = await HeroSectionModel.findAll({
      where: {
        status: 1,
      },
    });

    // if (!result) {
    //   return errorResponse(404, "NOT FOUND", "NO Active data found", res);
    // }

    return successResponse(200, "OK", result, res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err.message || "There was a server side Error",
      res,
    );
  }
};

// update

exports.update = async (req, res) => {
  try {
    const { id } = req.params;

    const isExist = await HeroSectionModel.findByPk(id);

    if (!isExist) {
      return errorResponse(404, "NOT FOUND", "No data found with this id", res);
    }
    const data = req.body;

    const { files } = req;

    const heroSectionData = {
      title: data?.title,
      description: data?.description,
      banner_img:
        files?.find((file) => file?.fieldname === "banner_img")?.filename ||
        isExist?.banner_img,
      side_img:
        files?.find((file) => file?.fieldname === "side_img")?.filename ||
        isExist?.side_img,
      button_title: data?.button_title,
      button_link: data?.button_link,
      status: data?.status,
    };

    console.log(heroSectionData);

    const result = await HeroSectionModel.update(heroSectionData, {
      where: {
        id,
      },
    });

    if (!result.includes(1)) {
      return errorResponse(404, "FAILED", "Failed to update new Banner", res);
    }

    return successResponse(201, "OK", "Update Successfully", res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err?.message || "There is a server side problem",
      res,
    );
  }
};

// delete heroSection

exports.delete = async (req, res) => {
  try {
    const { id } = req.params;

    const result = await HeroSectionModel.destroy({
      where: {
        id,
      },
    });

    if (result !== 1) {
      return errorResponse(
        404,
        "FAILED",
        "Hero section modal deleted failed",
        res,
      );
    }

    return successResponse(204, "OK", "Hero section deleted successfully", res);
  } catch (err) {
    return errorResponse(500, "ERROR", "There is a server side error", res);
  }
};
