const facilityRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const facilityController = require('../controllers/facility.controller');

module.exports = (app) => {
    facilityRouter.post('/', websiteImageUpload, facilityController.create);

    // get all

    facilityRouter.get('/', facilityController.getAll);

    // get active data

    facilityRouter.get('/active', facilityController.getActiveData);

    // update

    facilityRouter.put('/:id', websiteImageUpload, facilityController.update);

    // delete

    facilityRouter.delete('/:id', facilityController.delete);

    app.use('/api/facility-management', facilityRouter);
};
