const db = require('../../../../config/database.config');

const Package = db.model.package;
const PackageFeature = db.model.packageFeature;
const { PackageCategory } = db.model;
const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');

exports.getActivePackage = async (req, res) => {
    try {
        const packages = await Package.findAll({
            where: {
                status: 1,
            },
            include: [
                {
                    model: PackageFeature,
                    order: [['id', 'ASC']],
                    separate: true,
                },
                {
                    model: PackageCategory,
                    as: 'packageCat',
                    attributes: ['name', 'info'],
                },
            ],
            order: [['id', 'DESC']],
        });
        if (packages) {
            successResponse(200, 'OK', packages, res);
        }
    } catch (err) {
        errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while Creating Package',
            res
        );
    }
};

exports.getOneActivePackage = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await Package.findOne({
            where: {
                id,
                status: 1,
            },
            include: [
                {
                    model: PackageFeature,
                    order: [['id', 'ASC']],
                    separate: true,
                },
                {
                    model: PackageCategory,
                    as: 'packageCat',
                    attributes: ['name', 'info'],
                },
            ],
        });

        if (!result) {
            return errorResponse(500, 'ERROR', 'Package not found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while Creating Package',
            res
        );
    }
};
