const DestinationRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const DestinationController = require('../controller/destination.controller');

module.exports = (app) => {
    DestinationRouter.post('/', websiteImageUpload, DestinationController.create);

    // get all

    DestinationRouter.get('/', DestinationController.getAll);

    // get active data

    DestinationRouter.get('/active', DestinationController.getActiveData);

    // get by id

    DestinationRouter.get('/:id', DestinationController.getOne);

    // update

    DestinationRouter.put('/:id', websiteImageUpload, DestinationController.update);

    // delete

    DestinationRouter.delete('/:id', DestinationController.delete);

    app.use('/api/destination', DestinationRouter);
};
