module.exports = (sequelize, DataTypes) => {
    const courses = sequelize.define(
        'courses',
        {
            title: {
                type: DataTypes.STRING,
            },
            course_cat: {
                type: DataTypes.STRING,
            },
            instructor_id: {
                type: DataTypes.INTEGER,
            },
            date: {
                type: DataTypes.DATEONLY,
            },
            img: {
                type: DataTypes.STRING,
            },
            price: {
                type: DataTypes.FLOAT,
            },
            discounted_price: {
                type: DataTypes.FLOAT,
            },
            features: {
                type: DataTypes.TEXT,
            },
            duration: {
                type: DataTypes.STRING,
            },

            description: {
                type: DataTypes.TEXT,
            },
            status: {
                type: DataTypes.INTEGER,
                defaultValue: 1,
            },
        },
        {
            freezeTableName: true,
        }
    );

    return courses;
};
