const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');
const { model } = require('../../../../config/database.config');

const { courseRegistration, courses: CoursesModel } = model;

exports.getAllCourseReg = async (_, res) => {
    try {
        const result = await courseRegistration.findAll({
            include: [
                {
                    model: CoursesModel,
                },
            ],
        });
        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};
