const corporateLogoRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const corporateLogoController = require('../controller/corporateLogo.controller');

module.exports = (app) => {
    corporateLogoRouter.post('/', websiteImageUpload, corporateLogoController.create);

    // get all

    corporateLogoRouter.get('/', corporateLogoController.getAll);

    // get active data

    corporateLogoRouter.get('/active', corporateLogoController.getActiveData);

    // get one

    corporateLogoRouter.get('/:id', corporateLogoController.getOne);


    // update

    corporateLogoRouter.put('/:id', websiteImageUpload, corporateLogoController.update);

    // delete

    corporateLogoRouter.delete('/:id', corporateLogoController.delete);

    app.use('/api/corporate-logo', corporateLogoRouter);
};
