const contactRouter = require('express').Router();
const contactController = require('../controllers/contact.controller');

module.exports = (app) => {
    contactRouter.post('/', contactController.create);

    // get all the data

    contactRouter.get('/', contactController.getAll);

    // get one data

    contactRouter.get('/:id', contactController.getOne);

    // get active data

    contactRouter.get('/getData/active', contactController.getActiveData);

    // update hero hero-section

    contactRouter.put('/:id', contactController.update);

    // delete hero section
    contactRouter.delete('/:id', contactController.delete);

    app.use('/api/contact', contactRouter);
};
