const BookingRouter = require('express').Router();
// const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const bookingController = require('../controller/booking.controller');

module.exports = (app) => {
    BookingRouter.post('/', bookingController.create);

    // get all

    BookingRouter.get('/', bookingController.getAll);

    // get one

    BookingRouter.get('/:id', bookingController.getOne);

    // get active data

    BookingRouter.get('/active', bookingController.getActiveData);

    // update

    BookingRouter.put('/:id', bookingController.update);

    // delete

    BookingRouter.delete('/:id', bookingController.delete);

    app.use('/api/booking', BookingRouter);
};
