const blogRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const blogController = require('../controllers/blogs.controller');
const getActiveData = require('../controllers/getActiveData');
const getAllBlogsByCatId = require('../controllers/getAllBlogDataByCatId');

module.exports = (app) => {
    blogRouter.post('/', websiteImageUpload, blogController.create);

    // get all

    blogRouter.get('/', blogController.getAll);

    // get one blog with id

    blogRouter.get('/:id', blogController.getOne);

    // get active data

    blogRouter.get('/get-blogs/active', getActiveData.getActiveData);

    // get blog data by category

    blogRouter.get('/active/category/:cat_id', getAllBlogsByCatId.getAllBlogsByCatId);

    // update

    blogRouter.put('/:id', websiteImageUpload, blogController.update);

    // delete

    blogRouter.delete('/:id', blogController.delete);

    app.use('/api/blogs', blogRouter);
};
