module.exports = (sequelize, DataTypes) => {
    const blogs = sequelize.define(
        'blogs',
        {
            title: {
                type: DataTypes.STRING,
            },
            blog_cat: {
                type: DataTypes.STRING,
            },
            blog_date: {
                type: DataTypes.DATEONLY,
            },
            blog_img: {
                type: DataTypes.STRING,
            },
            short_description: {
                type: DataTypes.STRING,
            },

            long_description: {
                type: DataTypes.TEXT,
            },
            status: {
                type: DataTypes.INTEGER,
                defaultValue: 1,
            },
        },
        {
            freezeTableName: true,
        }
    );

    return blogs;
};
