const registrationController = require('../controllers/registration.auth.controller');
const loginController = require('../controllers/login.auth.controller');
const otpVerifyController = require('../controllers/otp.auth.controller');
const verifyMobileController = require('../controllers/verifyMobile.auth.controller');
const passwordController = require('../controllers/password.auth.controller');

module.exports = function (app) {
    app.post('/api/website/user/signup', registrationController.signup);
    app.post('/api/website/user/signin', loginController.signin);
    app.post('/api/website/user/verify-phonenumber', verifyMobileController.verifyMobileNumber);
    app.put('/api/website/user/password', passwordController.password);
    app.get('/api/website/user/otp-generate', otpVerifyController.otpGenerate);
};
