const MissionVisionMottoRouter = require('express').Router();
const MissionVisionMottoController = require('../controllers/MissionVissionMotto.controller');

module.exports = (app) => {
    MissionVisionMottoRouter.post('/', MissionVisionMottoController.create);

    // get all

    MissionVisionMottoRouter.get('/', MissionVisionMottoController.getAll);

    // get one

    MissionVisionMottoRouter.get('/:id', MissionVisionMottoController.getOne);

    // get active data

    MissionVisionMottoRouter.get('/getData/active', MissionVisionMottoController.getActiveData);

    // update

    MissionVisionMottoRouter.put('/:id', MissionVisionMottoController.update);

    // delete

    MissionVisionMottoRouter.delete('/:id', MissionVisionMottoController.delete);

    app.use('/api/mission-vision-motto', MissionVisionMottoRouter);
};
