const expiryDateCalculate = (durationString) => {
    const today = new Date();
    const expiryDate = new Date(today);

    // Split the duration string into value and unit
    const parts = durationString.split(' ');

    const value = parseInt(parts[0], 10); // Extract the numeric value
    const unit = parts[1]?.toLowerCase(); // Extract the unit and convert to lowercase for case insensitivity

    // Determine the unit and add to expiry date
    switch (unit) {
        case 'days' || 'day':
            expiryDate.setDate(today.getDate() + value);
            break;
        case 'months' || 'month':
            expiryDate.setMonth(today.getMonth() + value);
            break;
        case 'years' || 'year':
            expiryDate.setFullYear(today.getFullYear() + value);
            break;
        default:
            expiryDate.setDate(today.getDate() + value);
    }

    console.log('Expiry date:', expiryDate.toDateString());
    return expiryDate;
};
module.exports = { expiryDateCalculate };
