const whyChooseUsRouter = require('express').Router();
const whyChooseUsController = require('../controllers/whyChooseUs.controller');

module.exports = (app) => {
    whyChooseUsRouter.post('/', whyChooseUsController.create);

    // get all

    whyChooseUsRouter.get('/', whyChooseUsController.getAll);

    // get active data

    whyChooseUsRouter.get('/active', whyChooseUsController.getActiveData);

    // update

    whyChooseUsRouter.put('/:id', whyChooseUsController.update);

    // delete

    whyChooseUsRouter.delete('/:id', whyChooseUsController.delete);

    app.use('/api/why_choose_us', whyChooseUsRouter);
};
