const VisaRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const visaController = require('../controller/visa.controller');

module.exports = (app) => {
    VisaRouter.post('/', websiteImageUpload, visaController.create);

    // get all

    VisaRouter.get('/', visaController.getAll);

    // get active data

    VisaRouter.get('/active', visaController.getActiveData);

    // get one

    VisaRouter.get('/:id', visaController.getOne);

    // update

    VisaRouter.put('/:id', websiteImageUpload, visaController.update);

    // delete

    VisaRouter.delete('/:id', visaController.delete);

    app.use('/api/visa', VisaRouter);
};
